

/* Erläuterungen + Hinweise 

  Aktuelle Abbildung: http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Strukturvergleiche_-_Basiselemente
  
  * Alle Tabellen die Abzuschläge enthalten werden auf einen Sammel-View 'TWawi.View_All_Abzu' abgebildet, 
    um sie nach außen einheitlich darstellen und suchen zu können. Der View enthält die Felder, die in allen Abzu-Tabellen
    vorkommen (oder vorkommen sollten) und kann die Abzu zur dbrid des Parent-Datensatzen zurückgeben.
  ** Bsp. um die Zuschläge an einem Epreis-Datensatz zu ermitteln 'SELECT * FROM TWawi.View_all_Abzu WHERE az_parent_id = :epreis.dbrid
  ** Fehlende Felder werden in diesem Sammelview entweder per JOIN angebunden oder NULL gesetzt      
  
  * Einzelviews für die Tabellen, in denen die Abzu-Datensätze liegen
  ** KEINE Joins, NULL - Werte oder Funktionsaufrufe. Dadurch sind die Views in PostgreSQL 9.3+ UPDATABLE
  ** Es kann normal per Insert, Update, Delete darauf gearbeitet werden. 
  ** Zusatzfelder der zugrunde liegenden Tabellen werden mit geändertem Vorsatz ebenfalls in den View aufgenommen  
  
*/


/************** Alle Zuschlagsviews droppen **************/
CREATE OR REPLACE FUNCTION TSystem.views__TWawi_Abzu__drop () RETURNS VOID AS $$
 BEGIN
   DROP FUNCTION IF EXISTS TWawi.Abzu__Create__from__source__by__srctbl_dbrid(VARCHAR, VARCHAR);
   DROP FUNCTION IF EXISTS TWawi.Abzu__Create__from__source__by__srcview_parent_id(VARCHAR, VARCHAR);
   DROP FUNCTION IF EXISTS TWawi.Abzu__Create__Insert(TWawi.View_All_Abzu, VARCHAR, VARCHAR, NUMERIC); 
   --
   DROP VIEW IF EXISTS TWawi.View_All_Abzu; --ACHTUNG Functions mit Type DROP
   DROP VIEW IF EXISTS TWawi.Abzu_View_Vorgabe;
   DROP VIEW IF EXISTS TWawi.Auftg_Abzu;
   DROP VIEW IF EXISTS TWawi.BelKopf_Abzu;
   DROP VIEW IF EXISTS TWawi.Adk1_Abzu;
   DROP VIEW IF EXISTS TWawi.AnfAngebot_Abzu;
   DROP VIEW IF EXISTS TWawi.Ldsdok_Abzu;
   DROP VIEW IF EXISTS TWawi.Epreis_Abzu;
   DROP VIEW IF EXISTS TWawi.Belegdokument_Abzu;
   DROP VIEW IF EXISTS TWawi.BelegPos_Abzu;
   --
   RETURN;
 END $$ LANGUAGE plpgsql;
--


/**************  Einzelviews für Abzutabellen und den Sammelview neu erstellen **************/
CREATE OR REPLACE FUNCTION TSystem.views__Twawi_abzu__recreate() RETURNS VOID AS $$
 BEGIN
    PERFORM TSystem.views__TWawi_Abzu__drop();
    -- Abzu - Vorgaben aus Stammdaten. UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.Abzu_View_Vorgabe AS
     SELECT 'twawi.abzu'::VARCHAR(40) AS az_view    , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'abzu'::VARCHAR(20)       AS az_table   , -- Tabelle aus der der Zuschlag kommt
            dbrid                                   , -- DBRID des Abzudatensatzes
            abz_id                AS az_id          , -- ID des Zuschlags
            abz_type              AS az_type        , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            -- abz_pos            AS az_pos         , -- Position
            abz_id                AS az_abz_id      , -- ID der Vorgabe
            -- abz_parent_id      AS az_parent_id   , -- ID des Datensatzes an dem der Zuschlag hängt
            -- abz_anzahl         AS az_anzahl      , -- Anzahl / Menge
            abz_betrag            AS az_betrag      , -- Betrag in Währung des Parent-Datensatzes
            abz_proz              AS az_proz        , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            abz_canskonto         AS az_canSkonto   , -- Gilt Skonto für den Zuschlag?
            abz_steu              AS az_scode       , -- Steuercode (meist gleich Parent)
            -- abz_steuproz       AS az_sproz       , -- Prozentsatz der Steuer
            abz_konto             AS az_konto       , -- Kontierung
            abz_visible           AS az_visible     , -- Auf Dokument sichtbar oder nicht?
            abz_zutxt             AS az_txt         , -- Zusätzlicher Hinweistext
            abz_zutxt_rtf         AS az_txt_rtf     , -- Zusätzlicher Hinweistext (RTF)
            abz_zutxt_int         AS az_txt_int     , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            -- abz_source_table   AS az_source_table, -- Aus welcher Quelle wurde Abzu hierhin kopiert
            -- abz_source_dbrid   AS az_source_dbrid, -- Aus welchem Datensatz wurde Abzu hierhin kopiert
            -- ZUSATZFELDER, nicht in Standard-Viewdefinition
            abz_txt               AS az_bez         , -- Bezeichnung des Zuschlags
            abz_aknr_old     , -- ?
            abz_inselbstko   , -- Wird in Selbskosten eingerechnet
            abz_einkauf      , -- Kann einkaufseitig verwendet werden
            abz_verkauf      , -- Kann verkaufseitig verwendet werden
            -- abz_matnr       -- ???! An eine bestimmte Materialnummer gebunden (Kupfer, gilt dann für alle Artikel die aus Kupfer sind
            abz_ungueltig         AS az_ungueltig
       FROM abzu;
    
    -- Abzu an Auftragspositionen. UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.Auftg_Abzu AS
     SELECT 'twawi.auftg_abzu'::VARCHAR(40) AS az_view  , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'auftgabzu'::VARCHAR(20)        AS az_table , -- Tabelle aus der der Zuschlag kommt
            dbrid                                       , -- DBRID des Abzudatensatzes
            az_id                    AS az_id           , -- ID des Zuschlags
            az_type                  AS az_type         , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            az_pos                   AS az_pos          , -- Position
            az_abz_id                AS az_abz_id       , -- ID der Vorgabe
            az_ag_id                 AS az_parent_id    , -- ID des Datensatzes an dem der Zuschlag hängt
            az_anz                   AS az_anzahl       , -- Anzahl / Menge
            az_abzubetrag            AS az_betrag       , -- Betrag in Währung des Parent-Datensatzes
            az_abzuproz              AS az_proz         , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            az_canSkonto             AS az_canSkonto    , -- Gilt Skonto für den Zuschlag?
            az_steucode              AS az_scode        , -- Steuercode (meist gleich Parent)
            az_steuproz              AS az_sproz        , -- Prozentsatz der Steuer
            az_konto                 AS az_konto        , -- Kontierung
            az_visible               AS az_visible      , -- Auf Dokument sichtbar oder nicht?
            az_zutxt                 AS az_txt          , -- Zusätzlicher Hinweistext
            az_zutxt_rtf             AS az_txt_rtf      , -- Zusätzlicher Hinweistext (RTF)
            az_zutxt_int             AS az_txt_int      , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            az_source_table          AS az_source_table , -- Aus welcher Quelle wurde Abzu hierhin kopiert
            az_source_dbrid          AS az_source_dbrid , -- Aus welchem Datensatz wurde Abzu hierhin kopiert
            -- ZUSATZFELDER,  nicht in Standard-Viewdefinition
            az_done                                     , -- Erledigt Kennzeichen, wenn vollständig in Rechnung übernommen
            az_bebnr                                      -- Rechnungsnummer(n) der Rechnung, auf der Zuschlag verrechnet wurde
       FROM auftgabzu;
    
    -- Abzu an Rechnung. UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.BelKopf_Abzu AS
     SELECT 'twawi.belkopf_abzu'::VARCHAR(40) AS az_view  , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'belabzu'::VARCHAR(20)            AS az_table , -- Tabelle aus der der Zuschlag kommt
            dbrid                                       , -- DBRID des Abzudatensatzes
            beaz_id                AS az_id             , -- ID des Zuschlags
            beaz_type              AS az_type           , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            beaz_pos               AS az_pos            , -- Position
            beaz_abz_id            AS az_abz_id         , -- ID der Vorgabe
            beaz_bebnr             AS az_parent_id      , -- ID des Datensatzes an dem der Zuschlag hängt
            beaz_anz               AS az_anzahl         , -- Anzahl / Menge
            beaz_abzubetrag        AS az_betrag         , -- Betrag in Währung des Parent-Datensatzes
            beaz_abzuproz          AS az_proz           , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            beaz_canSkonto         AS az_canSkonto      , -- Gilt Skonto für den Zuschlag?
            beaz_steu              AS az_scode          , -- Steuercode (meist gleich Parent)
            beaz_steuproz          AS az_sproz          , -- Prozentsatz der Steuer
            beaz_konto             AS az_konto          , -- Kontierung
            beaz_visible           AS az_visible        , -- Auf Dokument sichtbar oder nicht?
            beaz_zutxt             AS az_txt            , -- Zusätzlicher Hinweistext
            beaz_zutxt_rtf         AS az_txt_rtf        , -- Zusätzlicher Hinweistext (RTF)
            beaz_zutxt_int         AS az_txt_int        , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            beaz_source_table      AS az_source_table   , -- Aus welcher Quelle wurde Abzu hierhin kopiert
            beaz_source_dbrid      AS az_source_dbrid   , -- Aus welchem Datensatz wurde Abzu hierhin kopiert
            -- ZUSATZFELDER,  nicht in Standard-Viewdefinition
            beaz_agnr              , -- Auftrag aus dem der Zuschlag stammt
            beaz_agpos             , -- Auftrags-Pos. aus der der Zuschlag stammt
            beaz_belpos            , -- Zuordnung zu einer bestimmten RG-Position
            beaz_tot               , -- ? Summe
            beaz_tot_basis_w       , -- ? Summe in Basiswährung
            beaz_tot_steu          , -- ?
            beaz_tot_steu_basis_w    -- ?
       FROM belabzu;
    
    -- Abzu an Debitorendaten. UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.Adk1_Abzu AS
     SELECT 'twawi.adk1_abzu'::VARCHAR(40) AS az_view , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'adk1'::VARCHAR(20)            AS az_table, -- Tabelle aus der der Zuschlag kommt
            dbrid                                     , -- DBRID des Abzudatensatzes
            a1z_id                  AS az_id          , -- ID des Zuschlags
            a1z_type                AS az_type        , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            a1z_pos                 AS az_pos         , -- Position
            a1z_abz_id              AS az_abz_id      , -- ID der Vorgabe
            a1z_krz                 AS az_parent_id   , -- ID des Datensatzes an dem der Zuschlag hängt
            a1z_anz                 AS az_anzahl      , -- Anzahl / Menge
            a1z_betrag              AS az_betrag      , -- Betrag in Währung des Parent-Datensatzes
            a1z_proz                AS az_proz        , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            a1z_canskonto           AS az_canSkonto   , -- Gilt Skonto für den Zuschlag?
            a1z_steucode 	        AS az_scode       , -- Steuercode (meist gleich Parent)
            a1z_steuproz            AS az_sproz       , -- Prozentsatz der Steuer
            a1z_konto               AS az_konto       , -- Kontierung
            a1z_visible             AS az_visible     , -- Auf Dokument sichtbar oder nicht?
            a1z_zutxt               AS az_txt         , -- Zusätzlicher Hinweistext
            a1z_zutxt_rtf           AS az_txt_rtf     , -- Zusätzlicher Hinweistext (RTF)
            a1z_zutxt_int           AS az_txt_int     , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            a1z_source_table        AS az_source_table, -- Aus welcher Quelle wurde Abzu hierhin kopiert
            a1z_source_dbrid        AS az_source_dbrid, -- Aus welchem Datensatz wurde Abzu hierhin kopiert
            -- ZUSATZFELDER,  nicht in Standard-Viewdefinition
            a1z_aknr AS az_aknr -- TODO: Als a1z_aknr führen?! Artikel bei dem dieser Abzuschlag gezogen wird
       FROM adk1abzu;
    
    -- Abzu an Lieferantenangeboten. UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.AnfAngebot_Abzu AS
     SELECT 'twawi.anfangebot_abzu'::VARCHAR(40) AS az_view , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'anfabzu'::VARCHAR(20)               AS az_table, -- Tabelle aus der der Zuschlag kommt
            dbrid                                       , -- DBRID des Abzudatensatzes
            anfaz_id                AS az_id            , -- ID des Zuschlags
            anfaz_type              AS az_type          , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            anfaz_pos               AS az_pos           , -- Position
            anfaz_abz_id            AS az_abz_id        , -- ID der Vorgabe
            anfaz_aang_id           AS az_parent_id     , -- ID des Datensatzes an dem der Zuschlag hängt
            anfaz_anz               AS az_anzahl        , -- Anzahl / Menge
            anfaz_betr              AS az_betrag        , -- Betrag in Währung des Parent-Datensatzes
            anfaz_proz              AS az_proz          , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            anfaz_canSkonto         AS az_canSkonto     , -- Gilt Skonto für den Zuschlag?
            anfaz_steucode          AS az_scode         , -- Steuercode (meist gleich Parent)
            anfaz_steuproz          AS az_sproz         , -- Prozentsatz der Steuer
            anfaz_konto             AS az_konto         , -- Kontierung
            anfaz_visible           AS az_visible       , -- Auf Dokument sichtbar oder nicht?
            anfaz_zutxt             AS az_txt           , -- Zusätzlicher Hinweistext
            anfaz_zutxt_rtf         AS az_txt_rtf       , -- Zusätzlicher Hinweistext (RTF)
            anfaz_zutxt_int         AS az_txt_int       , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            anfaz_source_table      AS az_source_table  , -- Aus welcher Quelle wurde Abzu hierhin kopiert
            anfaz_source_dbrid      AS az_source_dbrid    -- Aus welchem Datensatz wurde Abzu hierhin kopiert
       FROM anfabzu;
    
    -- Abzu an Bestellungen. UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.Ldsdok_Abzu AS
     SELECT 'twawi.ldsdok_abzu'::VARCHAR(40) AS az_view , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'ldsabzu'::VARCHAR(20)           AS az_table, -- Tabelle aus der der Zuschlag kommt
            dbrid                                       , -- DBRID des Abzudatensatzes
            ldaz_id                 AS az_id            , -- ID des Zuschlags
            ldaz_type               AS az_type          , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            ldaz_pos                AS az_pos           , -- Position
            ldaz_abz_id             AS az_abz_id        , -- ID der Vorgabe
            ldaz_ld_id              AS az_parent_id     , -- ID des Datensatzes an dem der Zuschlag hängt
            ldaz_anz                AS az_anzahl        , -- Anzahl / Menge
            ldaz_betr               AS az_betrag        , -- Betrag in Währung des Parent-Datensatzes
            ldaz_proz               AS az_proz          , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            ldaz_canSkonto          AS az_canSkonto     , -- Gilt Skonto für den Zuschlag?
            ldaz_steucode           AS az_scode         , -- Steuercode (meist gleich Parent)
            ldaz_steuproz           AS az_sproz         , -- Prozentsatz der Steuer
            ldaz_konto              AS az_konto         , -- Kontierung
            ldaz_visible            AS az_visible       , -- Auf Dokument sichtbar oder nicht?
            ldaz_zutxt              AS az_txt           , -- Zusätzlicher Hinweistext
            ldaz_zutxt_rtf          AS az_txt_rtf       , -- Zusätzlicher Hinweistext (RTF)
            ldaz_zutxt_int          AS az_txt_int       , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            ldaz_source_table       AS az_source_table  , -- Aus welcher Quelle wurde Abzu hierhin kopiert
            ldaz_source_dbrid       AS az_source_dbrid  , -- Aus welchem Datensatz wurde Abzu hierhin kopiert
            -- ZUSATZFELDER, nicht in Standard-Viewdefinition
            ldaz_done               AS az_done            -- Erledigt-Kennzeichen, wenn Zuschlag vollständig auf Eingangsrechnung übernommen wurde.
       FROM ldsabzu;
    
    -- Abzu an Lieferantenpreisen. UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.Epreis_Abzu AS
     SELECT 'twawi.epreis_abzu'::VARCHAR(40)  AS az_view , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'epreisabzu'::VARCHAR(20)         AS az_table, -- Tabelle aus der der Zuschlag kommt
            dbrid                                        , -- DBRID des Abzudatensatzes
            eaz_id                    AS az_id           , -- ID des Zuschlags
            eaz_type                  AS az_type         , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            eaz_pos                   AS az_pos          , -- Position
            eaz_abz_id                AS az_abz_id       , -- ID der Vorgabe
            eaz_e_id                  AS az_parent_id    , -- ID des Datensatzes an dem der Zuschlag hängt
            eaz_anz                   AS az_anzahl       , -- Anzahl / Menge
            eaz_betr                  AS az_betrag       , -- Betrag in Währung des Parent-Datensatzes
            eaz_proz                  AS az_proz         , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            eaz_canSkonto             AS az_canSkonto    , -- Gilt Skonto für den Zuschlag?
            eaz_steucode              AS az_scode        , -- Steuercode (meist gleich Parent)
            eaz_steuproz              AS az_sproz        , -- Prozentsatz der Steuer
            eaz_konto                 AS az_konto        , -- Kontierung
            eaz_visible               AS az_visible      , -- Auf Dokument sichtbar oder nicht?
            eaz_zutxt                 AS az_txt          , -- Zusätzlicher Hinweistext
            eaz_zutxt_rtf             AS az_txt_rtf      , -- Zusätzlicher Hinweistext (RTF)
            eaz_zutxt_int             AS az_txt_int      , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            eaz_source_table          AS az_source_table , -- Aus welcher Quelle wurde Abzu hierhin kopiert
            eaz_source_dbrid          AS az_source_dbrid   -- Aus welchem Datensatz wurde Abzu hierhin kopiert
       FROM epreisabzu;
    
    -- Dokumentbezogene Zuschläge an Belegen (ERG). UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.Belegdokument_Abzu AS
     SELECT 'twawi.belegdokument_abzu'::VARCHAR(40) AS az_view , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'belegabzu'::VARCHAR(20)                AS az_table, -- Tabelle aus der der Zuschlag kommt
            dbrid                                       , -- DBRID des Abzudatensatzes
            belaz_id                 AS az_id           , -- ID des Zuschlags
            belaz_type               AS az_type         , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            belaz_pos                AS az_pos          , -- Position
            belaz_abzu_id            AS az_abz_id       , -- ID der Vorgabe
            belaz_dokument_id        AS az_parent_id    , -- ID des Datensatzes an dem der Zuschlag hängt
            belaz_anzahl             AS az_anzahl       , -- Anzahl / Menge
            belaz_betrag             AS az_betrag       , -- Betrag in Währung des Parent-Datensatzes
            belaz_prozent            AS az_proz         , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            belaz_canskonto          AS az_canSkonto    , -- Gilt Skonto für den Zuschlag?
            belaz_steucode           AS az_scode        , -- Steuercode (meist gleich Parent)
            belaz_steuproz           AS az_sproz        , -- Prozentsatz der Steuer
            belaz_konto              AS az_konto        , -- Kontierung
            belaz_visible            AS az_visible      , -- Auf Dokument sichtbar oder nicht?
            belaz_zutxt              AS az_txt          , -- Zusätzlicher Hinweistext
            belaz_zutxt_rtf          AS az_txt_rtf      , -- Zusätzlicher Hinweistext (RTF)
            belaz_zutxt_int          AS az_txt_int      , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            belaz_source_table       AS az_source_table , -- Aus welcher Quelle wurde Abzu hierhin kopiert
            belaz_source_dbrid       AS az_source_dbrid , -- Aus welchem Datensatz wurde Abzu hierhin kopiert
            -- ZUSATZFELDER, nicht in Standard-Viewdefinition
            belaz_belegtyp   , --
            belaz_canrabatt  ,
            belaz_vorgaenger ,
            belaz_ks_abt
       FROM belegabzu;
    
    -- Positionsbezogene Zuschläge an Belegposition (ERG). UPDATABLE, wenn PostreSQl >= 9.3 und az_table beim Insert ausgelassen wird.
    CREATE OR REPLACE VIEW TWawi.BelegPos_Abzu AS
     SELECT 'twawi.belegpos_abzu'::VARCHAR(40) AS az_view , -- Names des TWawi-Views, der die Abzu-Tabelle kapselt
            'belegposabzu'::VARCHAR(20)        AS az_table, -- Tabelle aus der der Zuschlag kommt
            dbrid                                         , -- DBRID des Abzudatensatzes
            belpaz_id                   AS az_id          , -- ID des Zuschlags
            belpaz_type                 AS az_type        , -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
            belpaz_pos                  AS az_pos         , -- Position
            belpaz_abzu_id              AS az_abz_id      , -- ID der Vorgabe
            belpaz_belegpos_id          AS az_parent_id   , -- ID des Datensatzes an dem der Zuschlag hängt
            belpaz_anzahl               AS az_anzahl      , -- Anzahl / Menge
            belpaz_betrag               AS az_betrag      , -- Betrag in Währung des Parent-Datensatzes
            belpaz_prozent              AS az_proz        , -- Prozentualer Zuschlag auf Basis des Parent-Betrags
            belpaz_canskonto            AS az_canSkonto   , -- Gilt Skonto für den Zuschlag?
            belpaz_steucode             AS az_scode       , -- Steuercode (meist gleich Parent)
            belpaz_steuproz             AS az_sproz       , -- Prozentsatz der Steuer
            belpaz_konto                AS az_konto       , -- Kontierung
            belpaz_sichtbar             AS az_visible     , -- Auf Dokument sichtbar oder nicht?
            belpaz_zutxt                AS az_txt         , -- Zusätzlicher Hinweistext
            belpaz_zutxt_rtf            AS az_txt_rtf     , -- Zusätzlicher Hinweistext (RTF)
            belpaz_zutxt_int            AS az_txt_int     , -- Interner zusatztext (erscheint nicht auf Dokumenten)
            belpaz_source_table         AS az_source_table, -- Aus welcher Quelle wurde Abzu hierhin kopiert
            belpaz_source_dbrid         AS az_source_dbrid, -- Aus welchem Datensatz wurde Abzu hierhin kopiert
            -- ZUSATZFELDER, nicht in Standard-Viewdefinition                                              --
            belpaz_belegtyp,
            belpaz_canrabatt,
            belpaz_vorgaenger
     FROM belegposabzu;
    
    
    -- SAMMELVIEW: Enthält alle Felder, die die Views gemeinsamen haben und stellt sie über alle Tabelle einheitlichen dar.
      -- mit PG-9.3 NICHT UPDATEFÄHIG
    CREATE OR REPLACE VIEW TWawi.View_All_Abzu AS
     SELECT
            az_view, az_table, sqViews.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
            az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
            az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, az_done,
            az_parent_dbrid,   lang_abzu(az_abz_id, curr_lang()) AS az_bez
     FROM (
            -- Auftragsposition
        SELECT az_view, az_table, Auftg_Abzu.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
               az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, az_done,
               auftg.dbrid AS az_parent_dbrid
          FROM TWawi.Auftg_Abzu
               JOIN auftg ON ag_id = az_parent_id

      UNION -- Rechnungsposition
        SELECT az_view, az_table, BelKopf_Abzu.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
               az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, FALSE,
               belkopf.dbrid AS az_parent_dbrid
          FROM TWawi.BelKopf_Abzu 
               JOIN belkopf ON be_bnr = az_parent_id

      UNION -- Debitorendaten
        SELECT az_view, az_table, Adk1_Abzu.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
               az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, FALSE,
               adk1.dbrid AS az_parent_dbrid
          FROM TWawi.Adk1_Abzu 
               LEFT JOIN adk1 ON a1_krz = az_parent_id OR az_parent_id/*a1z_krz*/ IS null -- #21333 alle Abzschläge-Artikel meiner Adresse, oder Abzuschläge OHNE Zuordnung (heißt im Artikel und gilt für alle Adressen). Das "OR" ist  analog >>> constructor TPreisAbzu.Create <<< anzupassen!

      UNION -- Lieferantendaten
        SELECT az_view, az_table, Epreis_Abzu.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
               az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, FALSE,
               epreis.dbrid AS az_parent_dbrid     
          FROM TWawi.Epreis_Abzu 
               JOIN epreis ON e_id = az_parent_id

      UNION -- Lieferantenangebot
        SELECT az_view, az_table, AnfAngebot_Abzu.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
               az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, FALSE,
               anfangebot.dbrid AS az_parent_dbrid
          FROM TWawi.AnfAngebot_Abzu 
               JOIN anfangebot ON aang_id = az_parent_id

      UNION -- Bestellposition
        SELECT az_view, az_table, Ldsdok_Abzu.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
               az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, az_done,
               Ldsdok.dbrid AS az_parent_dbrid
          FROM TWawi.Ldsdok_Abzu 
               JOIN ldsdok ON ld_id = az_parent_id

      UNION -- Belegdokument
        SELECT az_view, az_table, Belegdokument_Abzu.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
               az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, FALSE,
               eingrechdokument.dbrid AS az_parent_dbrid
          FROM TWawi.Belegdokument_Abzu 
               JOIN eingrechdokument ON beld_id = az_parent_id

      UNION -- Belegposition
        SELECT az_view, az_table, BelegPos_Abzu.dbrid, az_id, az_type, az_pos, az_abz_id, az_parent_id :: varchar(40),
               az_anzahl, az_betrag, az_proz, az_canSkonto, az_scode, az_sproz, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table, az_source_dbrid, FALSE,
               eingrech_pos.dbrid AS az_parent_dbrid
          FROM TWawi.BelegPos_Abzu
               JOIN eingrech_pos ON belp_id = az_parent_id

      UNION -- Vorgabetabelle
        SELECT az_view, az_table, dbrid, az_id, az_type, NULL, az_abz_id, NULL,
               NULL, az_betrag, az_proz, az_canSkonto, az_scode, NULL, az_konto,
               az_visible, az_txt, az_txt_rtf, az_txt_int, NULL, NULL, FALSE,
               NULL
          FROM TWawi.Abzu_View_Vorgabe
     ) AS sqViews;
    --


    -- Wrapper für Typ-Abhängige Funktionen
    EXECUTE $f$
            CREATE OR REPLACE FUNCTION TWawi.Abzu__Create__from__source__by__srctbl_dbrid(
                IN p_source_table varchar, 
                IN p_source_dbrid varchar
                ) 
                RETURNS SETOF     TWawi.View_All_Abzu 
                AS $wrapper$
                BEGIN
                   RETURN QUERY 
                          SELECT (jsonb_populate_record(NULL::TWawi.View_All_Abzu, abzu)).* 
                            FROM TWawi.Abzu__Create__from__source__by__srctbl_dbrid__jsonb(p_source_table, p_source_dbrid) AS abzu;
                END $wrapper$ LANGUAGE plpgsql IMMUTABLE STRICT;
            --
            CREATE OR REPLACE FUNCTION TWawi.Abzu__Create__from__source__by__srcview_parent_id(
                IN srcView        varchar, 
                IN srcParentID    varchar
                ) 
                RETURNS SETOF     TWawi.View_All_Abzu 
                AS $wrapper$   
                BEGIN
                   RETURN QUERY 
                          SELECT (jsonb_populate_record(NULL::TWawi.View_All_Abzu, abzu)).* 
                            FROM TWawi.Abzu__Create__from__source__by__srctbl_dbrid__jsonb(srcView, srcParentID) AS abzu;
                END $wrapper$ LANGUAGE plpgsql IMMUTABLE STRICT;
            --
            CREATE OR REPLACE FUNCTION TWawi.Abzu__Create__Insert(
                IN rec_abzu       TWawi.View_All_Abzu, 
                IN trgView        varchar, 
                IN trgParentID    varchar, 
                IN trgMenge       numeric
                ) 
                RETURNS           varchar 
                AS $wrapper$
                BEGIN
                   RETURN * 
                     FROM TWawi.Abzu__Create__Insert__jsonb(to_jsonb(rec_abzu), trgView, trgParentID, trgMenge);
                END $wrapper$ LANGUAGE plpgsql;
    $f$

   RETURN;
 END $$ LANGUAGE plpgsql;
--



-- Alle Abzu-Views erstellen
SELECT TSystem.views__Twawi_abzu__recreate();

-- Einmal den Gesamtview testweise abfragen 
SELECT * FROM TWawi.View_All_Abzu LIMIT 1;
